function [y_1,y_2,y_3,y_4] = ...
    fault_slip_intersect_num(a,alpha,b,delta,delta_c,D_center,eps_reg,eta_reg,flag_fric,...
    flag_reg,g,kappa,K_eff,mu_dyn,mu_st,nu,p_0_center,p_inc,phi,rho_f,rho_s,sigma_v_0,...
    theta,y_delta)
%
% Computes the intersections y_1, y_2, y_3 and y_4 of the combined shear stress with the right
% slip boundary, i.e. the zeros of the pre-slip Coulomb stress sigma_C.  
%

small = 1e-12; 
y_1_0 =   [-b+small -a-small]; % interval containing initial guess
y_2_0 =   [-a+small  0      ];
y_3_0 =   [ 0        a-small];
y_4_0 =   [ a+small  b-small];
narrow_peak_bot = 0;
narrow_peak_top = 0;
try
y_1 = fzero(@(y) fault_slip_resid_intersect(a,alpha,b,delta,delta_c,D_center,eps_reg,...
    eta_reg,flag_fric,flag_reg,g,kappa,K_eff,mu_dyn,mu_st,nu,p_0_center,p_inc,phi,rho_f,...
    rho_s,sigma_v_0,theta,y,y_delta),y_1_0);
catch MExc
    if strcmp(MExc.identifier,'MATLAB:fzero:ValuesAtEndPtsSameSign') % no sign change at end
        % points detected by fzero
        y_1 = -a-small;
        y_2 = -a+small;
        narrow_peak_bot = 1;
    else % other error encountered by fzero
        error('Fatal error in fzero while computing y_1.')
    end
end
try
    y_4 = fzero(@(y) fault_slip_resid_intersect(a,alpha,b,delta,delta_c,D_center,eps_reg,...
        eta_reg,flag_fric,flag_reg,g,kappa,K_eff,mu_dyn,mu_st,nu,p_0_center,p_inc,phi,rho_f,...
        rho_s,sigma_v_0,theta,y,y_delta),y_4_0);
catch MExc
    if strcmp(MExc.identifier,'MATLAB:fzero:ValuesAtEndPtsSameSign') % no sign change at end
        % points detected by fzero
        y_4 = a+small;
        y_3 = a-small;
        narrow_peak_top = 1;
    else % other error encountered by fzero
        error('Fatal error in fzerow hile computing y_4.')
    end
end
if narrow_peak_bot == 0
    try
        y_2 = fzero(@(y) fault_slip_resid_intersect(a,alpha,b,delta,delta_c,D_center,...
            eps_reg,eta_reg,flag_fric,flag_reg,g,kappa,K_eff,mu_dyn,mu_st,nu,p_0_center,...
            p_inc,phi,rho_f,rho_s,sigma_v_0,theta,y,y_delta),y_2_0);
    catch MExc
        if strcmp(MExc.identifier,'MATLAB:fzero:ValuesAtEndPtsSameSign') % no sign change ...
            % at end points detected by fzero
            y_2 = 0; % merging has occurred
        else % other error encountered by fzero
            error('Fatal error in fzero while computing y_2.')
        end
    end
end
if narrow_peak_top == 0
    try
        y_3 = fzero(@(y) fault_slip_resid_intersect(a,alpha,b,delta,delta_c,D_center,...
            eps_reg,eta_reg,flag_fric,flag_reg,g,kappa,K_eff,mu_dyn,mu_st,nu,p_0_center,...
            p_inc,phi,rho_f,rho_s,sigma_v_0,theta,y,y_delta),y_3_0);
    catch MExc
        if strcmp(MExc.identifier,'MATLAB:fzero:ValuesAtEndPtsSameSign') % no sign change ...
            % at end points detected by fzero
            y_3 = 0; % merging has occurred
        else % other error encountered by fzero
            error('Fatal error in fzero while computing y_3.')
        end
    end
end